require( "scripts/style.lua" );
require( "scripts/tutorials_window.lua" );

PlusImage= "gamepiece/plus";
MinusImage="gamepiece/minus";  --        MinusImage=""


PlusImageTable = {image=PlusImage};


ScoresFont = {
  standardFont,
  30,
  WhiteColor
};

delta = 11;
current = 25;
OffsetY = 0;
OffsetX = 3;
delta_Y_ArrowPanelIndicator = 0;

ScoresHintText = {
                        fontname="gold",
                        x=0, y=0, w=150, h=80,
                        UnderLineDistance = 2;
                        HorSymbolDistance=-2;
                 }
ScoresHintText1 = {
                        font = {  standardFont, 24, BlackColor },
                        x=0, y=0, w=150, h=80,
                        UnderLineDistance = 2;
                        flags = kHAlignCenter + kVAlignCenter;
                        label="";
                 }


DefScoreBitmap = { name="image" };
DefScoreText={name="label", w=60, h=40, x=25, y=0};


gPlayerX = 0;
fIconDeltaY = 42;
IconOffsetX = 10;
IconOffsetY = 10;

function NextControl()
  current = current - 1;
end;

function NextPlayerIcon()
   gPlayerX = gPlayerX  + 1;
end

if (gEndlessDifficulty < 1 or gEndlessDifficulty > 3) then 
    gEndlessDifficulty = 1;
end

kCountHearts = gGlobalGameInfo.gCountHearts[gEndlessDifficulty];
kPosHearts = 135;
kHeartsFull = "panels/hearts10.png";
kHeartsNo = "panels/hearts0.png";

function RecalcPosHearts()
    kCountHearts = gGlobalGameInfo.gCountHearts[gEndlessDifficulty];
    kPosHearts = 135;
    if (kCountHearts == 4) then
        kPosHearts = 149;
    else
        if (kCountHearts == 3) then
            kPosHearts = 165;
        end
    end
    return kPosHearts;
end
    
RecalcPosHearts();

-- Our mini-game set-up
MakeDialog
{
    -- Name the modal dialog
    name="thegame",
    ParamTimer
    {
        param = "PlayTime";
    }; 
    
    SCursor
    {
        w=800,
        h=600,
        image="backgrounds/shadow";
        
        
        
        Window
        {
            name="backgroundimage",
            h=600,
            w=800,

            GameWindow
            {
                name="game_window",
                x=0,
                y=0,
                w=800,
                h=600,              
                rows=gRows,
                columns=gColumns,
            },
            
            SunLevelImage
            { 
                name="day_timing",
                image="panels/day_timer/timer%.4d.png",
                
                max_play = 52;              
                ChangingTime = 500;
                StartFrame = 1;

                
                x=123,
                y=548,
                w=335,
                h=94,    

            },
            Bitmap
            { 
                name="day_timing_endless",
                image="panels/endless_timer_bg.png",
                x=123,
                y=548,
                w=335,
                h=94,    
            },
            Bitmap
            { 
                name="hearts1";
                image=kHeartsFull,
                x=kPosHearts,
                y=560,
                w=25,
                h=25,           
            },                                              
            Bitmap
            { 
                name="hearts2";
                image=kHeartsFull,
                x=kPosHearts + 30,
                y=560,
                w=25,
                h=25,           
            },                                              
            Bitmap
            { 
                name="hearts3";
                image=kHeartsFull,
                x=kPosHearts + 30 * 2,
                y=560,
                w=25,
                h=25,           
            },                                              
            Bitmap
            { 
                name="hearts4";
                image=kHeartsFull,
                x=kPosHearts + 30 * 3,
                y=560,
                w=25,
                h=25,           
            },                                              
            Bitmap
            { 
                name="hearts5";
                image=kHeartsFull,
                x=kPosHearts + 30 * 4,
                y=560,
                w=25,
                h=25,           
            },                                              
        },
--[[    
            Window
            {
                name="pluses_window",
                w=800, 
                h=600,
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);;
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
                Bitmap(PlusImageTable);
            },
--]]            
        ScoresHintPanel
        {
            name="ScoresHintPanel",
            w=800, h=600,
            Text(ScoresHintText1); --BitmapText(ScoresHintText);
            Text(ScoresHintText1); --BitmapText(ScoresHintText);
            Text(ScoresHintText1); --BitmapText(ScoresHintText);
            Text(ScoresHintText1); --BitmapText(ScoresHintText);
            Text(ScoresHintText1); --BitmapText(ScoresHintText);
            Text(ScoresHintText1); --BitmapText(ScoresHintText);
            Text(ScoresHintText1); --BitmapText(ScoresHintText);
            Text(ScoresHintText1); --BitmapText(ScoresHintText);
            Text(ScoresHintText1); --BitmapText(ScoresHintText);
            Text(ScoresHintText1); --BitmapText(ScoresHintText);
        },
    
        Bitmap
        { 
            name="interface_panel",
            image="panels/panel",
            x=1,
            y=525,
            w=800,
            h=56,
            Text
            {
                font = {  standardFont, 30, GreenColor },
                name = "num_level",
                x=5,y=35,w=110,h=50,
                flags = kHAlignCenter,
                label = "";
            },          
            Text
            {
                font = {  standardFont, 24, GreenColor },
                name = "num_level_endl",
                x=0,y=40,w=115,h=50,
                flags = kHAlignCenter,
                label = "";
            },          
            Text
            {
                font = {  standardFont, 18, GreenColor },
                name = "diff_level",
                x=5,y=27,w=110,h=50,
                flags = kHAlignCenter,
                label = "";
            },          
            
            Text
            {
                font = {  standardFont, 18, WhiteColor },
                name = "level_score",
                x=605,y=26,w=100,h=50,
                flags = kHAlignCenter,

                label = "scores_indicator0";
            },
            Window
            {
                name="score_group",
                x=285,
                y=0,  --32,
                w=370,
                h=71,
                
                ArrowIndicator
                {
                    name="score_indicator",
                    x=19,
                    y=42,
                    w=306,
                    h=38,
                    Arrow="panels/bar.png", --arrow_d",
                },
                
                ArrowPanelIndicator
                {
                    name="expert_indicator",
                    x=0,
                    y=10, --25 + delta_Y_ArrowPanelIndicator,
                    w=360,
                    h=35,
                    Arrow0="slider/interface_goal_pointer",          
                    Arrow1="slider/expertl_marker",          
                    Arrow0_endless="slider/interface_goal_pointer";
                    text0 = "win_score";
                    text1 = "expert_score";
                    win_delta_right = 130, --  Win
                    win_delta_right_endless = 130, --  Win
                    exp_delta_right = 130, --  Exp
                    Text
                    {
                        font = {  standardFont, 18, WhiteColor },
                        name = "win_score",
                        x=0,y=5,w=110,h=20,
                        flags = kHAlignCenter,
                        label = "win_score";
                    },          
                },
            },
            
            ButtonEx
            {
                x=700,
                y=15,
                w = 50,
                h = 50,
                font = StandardButtonFont, 
                graphics =  
                {
                    "buttons/menu_but_normal",
                    "buttons/menu_but_normal",
                    "buttons/menu_but_highlight"
                },
                name="pause",
                label="pause",
                sound = kDefaultButtonSound,
                type = kPush,
                command=
                    function()
                        if(PauseGame~=nil)then PauseGame(); end
                        DoModal("scripts/pause.lua");
                    end;
                Text
                {
                   -- font = MyFont,
                    name = "menu",
                    font = { standardFont, 30, BlackColor},
                    x=0,y=20,w=100,h=50,
                    flags = kHAlignCenter,
                    label = "menu";
                };  
            },      

--aaa            
        },
		
        
        SpritePlayer
        {
            name = "rooster",
			w = 120,
			h = 90,
			x = 0,
			y = 470,
			Sprite = "sprites/rooster_sw.xml";
			start = false,
        },
		
        Particle
        {
            name = "ScoreParticle",
            x=200,
            y=0,
            w=420,
            h=140,
        },

        Bitmap
        { 
            name="WinLabel",
            image="panels/goal_reached",
            x=220,
            y=0,
            --w=121,
            --h=40,
			Text
			{
				y = 13,
				w = 355,
				h = 76,
				flags = kHAlignCenter + kVAlignCenter,
				label = "goal_reached",
				font = { standardFont, 38, Color(2,89,136, 200) },
			}
        },
        
        Bitmap
        { 
            name="ExpertLabel",
            image="panels/expert_reached",
            x=220,
            y=0,
            --w=121,
            --h=40,
			Text
			{
				y = 13,
				w = 355,
				h = 76,
				flags = kHAlignCenter + kVAlignCenter,
				label = "expert_reached",
				font = { standardFont, 38, Color(153,0,0, 200) },
			}			
        },        
        
        
        
        TutorialWindow(DefaultTutorialWindow);       
        TutorialWindow(PreloadTutorialWindow);
        TutorialWindow(TelephonTutorialWindow);
        TutorialWindow(DownImageTutorialWindow);
        TutorialWindow(TwoButtonTutorial);

    },
    Bitmap
    { 
        name="EndDayImage",
        image="panels/day_is_over",
        x=280,
        y=220,
        flags = kHAlignCenter,
		Text
		{
	        x = 13,
	        w = 244,
	        h = 70,
			flags = kHAlignCenter + kVAlignCenter,
			label = "end_of_the_day",
			font = { standardFont, 32, Color(153,0,0, 200) },
		}			
    },                
}

SetPos("rooster", -120, 470);

effects=
{
RoosterCry  = { control="rooster", effect="interpolator", next_effect="RoosterCry1", params={ interval=600, vector={200,0}, hiding=false }},
RoosterCry1 = { control="rooster", effect="SoundEffect", next_effect="RoosterCry2", params={ name="end_play_level" }},
RoosterCry2 = { control="rooster", effect="StartSpritePlayer", next_effect="RoosterCry3", params={ WaitFinish=true }},
RoosterCry3 = { control="rooster", effect="interpolator", params={ interval=500, vector={-200,0}, hiding=false }},

WinGame=  { control="WinLabel", effect="interpolator", next_effect="WinGame1", params={ interval=600,alpha={127,255}, vector={0,25}, hiding=false }},
WinGame1= {control="ScoreParticle", effect="start_particle", next_effect="WinGame2",   params={ interval=1800, particle_script="scatter_stars" }},
WinGame2= {control="WinLabel",      effect="interpolator",   params={ interval=600,  alpha={255,127}, vector={0, -25}, hiding=true }},

ExpertGame=  { control="ExpertLabel", effect="interpolator", next_effect="ExpertGame1", params={ interval=600,alpha={127,255}, vector={0,25}, hiding=false }},
ExpertGame1= {control="ScoreParticle", effect="start_particle", next_effect="ExpertGame2",   params={ interval=1800, particle_script="scatter_stars" }},
ExpertGame2= {control="ExpertLabel",      effect="interpolator",   params={ interval=600,  alpha={255,127}, vector={0,-25}, hiding=true }},



EndDay=  {control="EndDayImage", effect="interpolator", next_effect="EndDay1", params={ interval=800, start_pos={800,250}, alpha={150,255}, vector={-530,0}, hiding=false }},
EndDay1=  {control="EndDayImage", effect="pause", next_effect="EndDay2", params={ interval=800}},
EndDay2=  {control="EndDayImage", effect="interpolator", params={ interval=800,  alpha={255, 150}, vector={-400,0}, hiding=true }},



ScorePlusFly = {control="", effect="mover", params={ destination={x=460,y=566}, Time=nil, Speed=400, route={{"elliptic", -1, param0=50}}, hiding=true }  },
--[[
             , 
  ()  , (),     
interval=2000, -    
 alpha={255,40},  -       ,  
 scale={1,1},           -        
 vector={0,50},     -      
 sin_x={10,10},     -       x,  x+= k*sin(a) 
 sin_y=nil,             -       y
 hiding=true          -       
--]]
--SetScore={control="",            effect="smoke",             params={ interval=1600, alpha={255,70}, scale={1,2}, vector={0,-50}, sin_x={5,4}, sin_y=nil, hiding=true  }};
SetScore={control="",            effect="smoke",             params={ interval=500,   vector={0,-25}, sin_x=nil, sin_y=nil, hiding=true  }};
SetScoreMinus={control="",            effect="smoke",             params={ interval=500,  vector={0,25}, sin_x=nil, sin_y=nil, hiding=true  }};

--ExpertParticle ={ control="ScoreParticle", effect="mover", params={ particle_script="scatter_stars" }};
};


function OnSwitchGameMode()
    if (gGameMode == 0) then
        EnableWindow("num_level",true);
        EnableWindow("diff_level",false);
        EnableWindow("num_level_endl",false);
        --SetLabel("num_level",GetString("num_level_text",""..gGlobalPlayerInfo.gLevelNum));
        EnableWindow("day_timing_endless",false);   
        for i = 1, 5, 1 do
            EnableWindow("hearts"..i,false);
        end
    else
        EnableWindow("num_level",false);
        EnableWindow("diff_level",true);
        EnableWindow("num_level_endl",true);
        --SetLabel("num_level_endl",GetString("num_level_endless","" ..gCurFarm));
        --SetLabel("diff_level",GetString("level_endless_diff"..gEndlessDifficulty));
        EnableWindow("day_timing_endless",true);   
        for i = 1, kCountHearts, 1 do
            EnableWindow("hearts"..i,true);
        end
        for i = kCountHearts+1, 5, 1 do
            EnableWindow("hearts"..i,false);
        end
    end
end

function ShowLifeHearts(aCountFullShow,aHalfShow)
    for i = 1, kCountHearts, 1 do
        if (i <= aCountFullShow) then
            SetBitmap("hearts"..i,kHeartsFull,1);   
        else
            if (i == aCountFullShow + 1) then
                if (aHalfShow >= 1 and aHalfShow <= 10) then
                    SetBitmap("hearts"..i,"panels/hearts"..aHalfShow..".png",1);   
                else
                    SetBitmap("hearts"..i,kHeartsNo,1);   
                end
            else
                SetBitmap("hearts"..i,kHeartsNo,1);   
            end
        end
    end
end

require( "scripts/def_game.lua" );
OnInitComplete();

if( LevelForLoading ~= nil )then
    local number = LevelForLoading;
    LevelForLoading = nil;
    gGlobalPlayerInfo.gLevelNum=tonumber(number);
    LoadLevel(gGlobalPlayerInfo.gLevelNum);
else
    LoadLevel(gGlobalPlayerInfo.gLevelNum);
end
